/*
 * Decompiled with CFR 0.152.
 */
package netP5;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Bytes {
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String getAsString(Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuffer.append("[" + i + "]" + " " + objectArray[i] + "\n");
        }
        return stringBuffer.toString();
    }

    public static String getAsString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append((char)byArray[i]);
        }
        return stringBuffer.toString();
    }

    public static int toInt(byte[] byArray) {
        return (byArray[3] & 0xFF) + ((byArray[2] & 0xFF) << 8) + ((byArray[1] & 0xFF) << 16) + ((byArray[0] & 0xFF) << 24);
    }

    public static long toLong(byte[] byArray) {
        return ((long)byArray[7] & 0xFFL) + (((long)byArray[6] & 0xFFL) << 8) + (((long)byArray[5] & 0xFFL) << 16) + (((long)byArray[4] & 0xFFL) << 24) + (((long)byArray[3] & 0xFFL) << 32) + (((long)byArray[2] & 0xFFL) << 40) + (((long)byArray[1] & 0xFFL) << 48) + (((long)byArray[0] & 0xFFL) << 56);
    }

    public static float toFloat(byte[] byArray) {
        int n = Bytes.toInt(byArray);
        return Float.intBitsToFloat(n);
    }

    public static double toDouble(byte[] byArray) {
        long l = Bytes.toLong(byArray);
        return Double.longBitsToDouble(l);
    }

    public static byte[] toBytes(int n) {
        return Bytes.toBytes(n, new byte[4]);
    }

    public static byte[] toBytes(int n, byte[] byArray) {
        byArray[3] = (byte)n;
        byArray[2] = (byte)(n >>>= 8);
        byArray[1] = (byte)(n >>>= 8);
        byArray[0] = (byte)(n >>>= 8);
        return byArray;
    }

    public static byte[] toBytes(long l) {
        return Bytes.toBytes(l, new byte[8]);
    }

    public static byte[] toBytes(long l, byte[] byArray) {
        byArray[7] = (byte)l;
        byArray[6] = (byte)(l >>>= 8);
        byArray[5] = (byte)(l >>>= 8);
        byArray[4] = (byte)(l >>>= 8);
        byArray[3] = (byte)(l >>>= 8);
        byArray[2] = (byte)(l >>>= 8);
        byArray[1] = (byte)(l >>>= 8);
        byArray[0] = (byte)(l >>>= 8);
        return byArray;
    }

    public static boolean areEqual(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        if (n != byArray2.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static byte[] append(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    public static byte[] append(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = new byte[byArray.length + byArray2.length + byArray3.length];
        System.arraycopy(byArray, 0, byArray4, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray4, byArray.length, byArray2.length);
        System.arraycopy(byArray3, 0, byArray4, byArray.length + byArray2.length, byArray3.length);
        return byArray4;
    }

    public static byte[] copy(byte[] byArray, int n) {
        return Bytes.copy(byArray, n, byArray.length - n);
    }

    public static byte[] copy(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return byArray2;
    }

    public static void merge(byte[] byArray, byte[] byArray2, int n, int n2, int n3) {
        System.arraycopy(byArray, n, byArray2, n2, n3);
    }

    public static void merge(byte[] byArray, byte[] byArray2, int n) {
        System.arraycopy(byArray, 0, byArray2, n, byArray.length);
    }

    public static void merge(byte[] byArray, byte[] byArray2) {
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
    }

    public static void merge(byte[] byArray, byte[] byArray2, int n, int n2) {
        System.arraycopy(byArray, 0, byArray2, n, n2);
    }

    public static String toString(byte[] byArray, int n, int n2) {
        char[] cArray = new char[n2 * 2];
        int n3 = 0;
        for (int i = n; i < n + n2; ++i) {
            byte by = byArray[i];
            cArray[n3++] = hexDigits[by >>> 4 & 0xF];
            cArray[n3++] = hexDigits[by & 0xF];
        }
        return new String(cArray);
    }

    public static String toString(byte[] byArray) {
        return Bytes.toString(byArray, 0, byArray.length);
    }

    public static void printBytes(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            System.out.print((char)byArray[i] + " (" + hexDigits[byArray[i] >>> 4 & 0xF] + "" + hexDigits[byArray[i] & 0xF] + ")  ");
            if ((i + 1) % 4 != 0) continue;
            System.out.print("\n");
        }
    }

    private static byte[] toByteArray(int n) {
        byte[] byArray = new byte[4];
        for (int i = 0; i < 4; ++i) {
            byte by;
            int n2 = n >> i * 8 & 0xFF;
            byArray[i] = by = (byte)n2;
        }
        return byArray;
    }

    private static byte[] toByteArrayBigEndian(int n) {
        byte[] byArray = new byte[4];
        for (int i = 0; i < 4; ++i) {
            byte by;
            int n2 = n >> i * 8 & 0xFF;
            byArray[3 - i] = by = (byte)n2;
        }
        return byArray;
    }

    private static int asInt(byte[] byArray) {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            int n2 = byArray[i];
            if (i < 3 && n2 < 0) {
                n2 = 256 + n2;
            }
            n += n2 << i * 8;
        }
        return n;
    }

    public static int toIntLittleEndian(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[]{(byte)inputStream.read(), (byte)inputStream.read(), (byte)inputStream.read(), (byte)inputStream.read()};
        return Bytes.asInt(byArray);
    }

    public static int toIntBigEndian(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[4];
        byArray[3] = (byte)inputStream.read();
        byArray[2] = (byte)inputStream.read();
        byArray[1] = (byte)inputStream.read();
        byArray[0] = (byte)inputStream.read();
        return Bytes.asInt(byArray);
    }

    public static String toString(InputStream inputStream) throws IOException {
        int n = Bytes.toIntLittleEndian(inputStream);
        return Bytes.toString(inputStream, n);
    }

    private static String toString(InputStream inputStream, int n) throws IOException {
        String string = new String();
        for (int i = 0; i < n; ++i) {
            string = string + (char)inputStream.read();
        }
        return string;
    }

    public static void toStream(OutputStream outputStream, int n) throws Exception {
        byte[] byArray = Bytes.toByteArrayBigEndian(n);
        outputStream.write(byArray);
    }

    public static void toStream(OutputStream outputStream, String string) throws Exception {
        int n = string.length();
        Bytes.toStream(outputStream, n);
        for (int i = 0; i < n; ++i) {
            outputStream.write((byte)string.charAt(i));
        }
        outputStream.flush();
    }

    public static void toStream(OutputStream outputStream, byte[] byArray) throws Exception {
        int n = byArray.length;
        Bytes.toStream(outputStream, n);
        outputStream.write(byArray);
        outputStream.flush();
    }

    public static byte[] toByteArray(InputStream inputStream) throws IOException {
        int n = Bytes.toIntLittleEndian(inputStream);
        try {
            return Bytes.toByteArray(inputStream, n);
        }
        catch (Exception exception) {
            return new byte[0];
        }
    }

    protected static byte[] toByteArray(InputStream inputStream, int n) throws IOException, Exception {
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = 0;
        int n4 = n;
        while (n2 < n && (n3 = inputStream.read(byArray, n2, n4)) > 0) {
            n4 = n - (n2 += n3);
        }
        if (n2 < byArray.length) {
            throw new Exception("Could not completely read from stream, numRead=" + n3 + ", ret.length=" + byArray.length);
        }
        return byArray;
    }

    private static void toFile(InputStream inputStream, FileOutputStream fileOutputStream, int n, int n2) throws FileNotFoundException, IOException {
        byte[] byArray = new byte[n2];
        int n3 = 0;
        int n4 = 0;
        while (n4 + n2 <= n) {
            n3 = inputStream.read(byArray);
            n4 += n3;
            fileOutputStream.write(byArray, 0, n3);
        }
        if (n4 < n) {
            Bytes.toFile(inputStream, fileOutputStream, n - n4, n2 / 2);
        }
    }

    private static void toFile(InputStream inputStream, File file, int n) throws FileNotFoundException, IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        Bytes.toFile(inputStream, fileOutputStream, n, 1024);
    }

    public static void toFile(InputStream inputStream, File file) throws FileNotFoundException, IOException {
        int n = Bytes.toIntLittleEndian(inputStream);
        Bytes.toFile(inputStream, file, n);
    }

    public static void toStream(OutputStream outputStream, File file) throws FileNotFoundException, Exception {
        Bytes.toStream(outputStream, (int)file.length());
        byte[] byArray = new byte[1024];
        FileInputStream fileInputStream = new FileInputStream(file);
        int n = 0;
        while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
            outputStream.write(byArray, 0, n);
        }
        outputStream.flush();
    }
}

